/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Comparator;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.IEasing;
import lib.toma.animations.QuickSort;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.engine.frame.EmptyKeyframe;
import lib.toma.animations.engine.frame.Keyframe;
import lib.toma.animations.engine.frame.PositionKeyframe;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class Keyframes {
    private static final IKeyframe NULL_FRAME = Keyframes.wait(0.0f, AnimationUtils.DEFAULT_EASE_FUNC);

    public static void sortFrames(IKeyframe[] array) {
        QuickSort.sort(array, Comparator.comparingDouble(IKeyframe::endpoint));
    }

    public static Vector3d getInitialPosition(IKeyframe parent) {
        return parent.initialPosition().func_178787_e(parent.relativePos());
    }

    public static Vector3d getInitialRotation(IKeyframe parent) {
        Vector3d v1 = parent.initialRotation();
        Vector3d v2 = parent.relativeRot();
        return v1.func_178787_e(v2);
    }

    public static Vector3d getRelativePosition(Vector3d target, Vector3d initial) {
        return target.func_178788_d(initial);
    }

    public static Vector3d getRelativeRotation(Vector3d target, Vector3d initial) {
        return target.func_178788_d(initial);
    }

    public static void processFrame(IKeyframe keyframe, float percent, MatrixStack matrixStack) {
        float easedProgresss = keyframe.getEasing().ease(percent);
        Vector3d move1 = keyframe.initialPosition();
        Vector3d move2 = keyframe.relativePos();
        Quaternion q1 = keyframe.getInitialRotationQuaternion();
        Quaternion q2 = keyframe.getRotationQuaternion();
        Quaternion q3 = q2.func_227068_g_();
        q3.func_227065_a_(easedProgresss);
        matrixStack.func_227861_a_(move1.field_72450_a + move2.field_72450_a * (double)easedProgresss, move1.field_72448_b + move2.field_72448_b * (double)easedProgresss, move1.field_72449_c + move2.field_72449_c * (double)easedProgresss);
        matrixStack.func_227863_a_(q1);
        matrixStack.func_227863_a_(q3);
    }

    public static Quaternion rotationVector2Quaternion(Vector3d rotation) {
        if (rotation.equals((Object)Vector3d.field_186680_a)) {
            return Quaternion.field_227060_a_;
        }
        float r = (float)Keyframes.max(rotation);
        float x = (float)(rotation.field_72450_a / (double)r);
        float y = (float)(rotation.field_72448_b / (double)r);
        float z = (float)(rotation.field_72449_c / (double)r);
        Vector3f vector3f = new Vector3f(x, y, z);
        vector3f.func_229194_d_();
        return new Quaternion(vector3f, r, true);
    }

    public static IKeyframe none() {
        return NULL_FRAME;
    }

    public static IKeyframe wait(float endpoint, IEasing easing) {
        return EmptyKeyframe.wait(endpoint, easing);
    }

    public static IKeyframe position(Vector3d position, IEasing easing, float endpoint) {
        return PositionKeyframe.positioned(position, easing, endpoint);
    }

    public static IKeyframe keyframe(Vector3d position, Vector3d rotation, IEasing easing, float endpoint) {
        return Keyframe.of(position, rotation, easing, endpoint);
    }

    private static double max(Vector3d vector3d) {
        double x = Math.abs(vector3d.field_72450_a);
        double y = Math.abs(vector3d.field_72448_b);
        double z = Math.abs(vector3d.field_72449_c);
        return Math.max(x, Math.max(y, z));
    }
}

